#include <bits/stdc++.h>
#include <ext/pb_ds/assoc_container.hpp>

#define int long long
#define double long double

using namespace std;
using namespace __gnu_pbds;

struct pr {
    int x, y;

    friend pr operator+(pr a, pr b) {
        return {a.x + b.x, a.y + b.y};
    }

    friend pr operator-(pr a, pr b) {
        return {a.x - b.x, a.y - b.y};
    }
};

int dot(pr a, pr b) {
    return a.x * b.x + a.y * b.y;
}

int cross(pr a, pr b) {
    return a.x * b.y - a.y * b.x;
}

struct seg {
    pr A, B;

    friend istream& operator>>(istream& in, seg& a) {
        in >> a.A.x >> a.A.y >> a.B.x >> a.B.y;
        return in;
    }
};

int gcd(int x, int y) {
    if (y == 0)
        return x;
    return gcd(y, x % y);
}

struct line {
    int A, B, C;

    line(seg ab) {
        if (ab.B.x < ab.A.x)
            swap(ab.B, ab.A);
        if (ab.A.x != ab.B.x) {
            if (ab.A.y == ab.B.y) {
                A = 0, B = 1, C = -ab.A.y;
            } else {
                A = ab.B.x - ab.A.x;
                B = -(ab.B.y - ab.A.y);
                C = -(A * ab.A.y - B * ab.A.x);
                swap(A, B);
                if (A < 0) {
                    A *= -1;
                    B *= -1;
                    C *= -1;
                }

                //if (A != 0)
                int g = gcd(A, gcd(abs(B), abs(C)));
                A /= g;
                B /= g;
                C /= g;
            }
        } else {
            A = 1, B = 0, C = -ab.A.x;
        }
    }
};

bool is_intersect(seg a, seg b) {
    if (cross(b.A - a.A, a.B - a.A) * cross(b.B - a.A, a.B - a.A) <= 0 &&
        cross(a.A - b.A, b.B - b.A) * cross(a.B - b.A, b.B - b.A) <= 0)
        return true;
    return false;
}

pair<double, double> intersection(seg AB, seg CD) {
    line a(AB), b(CD);
    pair<double, double> O;
    O.first = (double) (a.C * b.B - a.B * b.C) / (double) (a.B * b.A - a.A * b.B);
    O.second = (-a.A * O.first - a.C) / a.B;
    return O;
}

struct dsu {
    vector<int> p;

    void init(int n) {
        p.resize(n);
        iota(p.begin(), p.end(), 0);
    }

    int get_root(int v) {
        if (p[v] == v)
            return v;
        return p[v] = get_root(p[v]);
    }

    void merge(int u, int v) {
        u = get_root(u);
        v = get_root(v);
        p[v] = u;
    }
};

void solve() {
    int n;
    cin >> n;
    vector<seg> segments(1);
    cin >> segments[0];
    int ans = 0;
    dsu group;
    group.init(n + 1);
    for (int i = 1; i < n; ++i) {
        seg now;
        cin >> now;
        vector<pair<pair<double, double>, int>> intersects;
        for (int j = 0; j < segments.size(); ++j) {
            if (is_intersect(now, segments[j])) {
                intersects.emplace_back(intersection(now, segments[j]), j);
            }
        }
        sort(intersects.begin(), intersects.end());
        for (int j = 0; j < (int) intersects.size() - 1; ++j) {
            if (group.get_root(intersects[j].second) == group.get_root(intersects[j + 1].second))
                ans++;
            group.merge(intersects[j].second, intersects[j + 1].second);
        }
        segments.push_back(now);
        for (int j = 0; j < intersects.size(); ++j) {
            group.merge(intersects[j].second, i);
        }
    }
    cout << ans + 1 << '\n';
}

signed main() {
    ios_base::sync_with_stdio(false), cin.tie(nullptr), cout.tie(nullptr);
    int t = 1;
    cin >> t;
    while (t--) {
        solve();
    }
}
